/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodParameterTypeInspection
extends EndpointInspectionBase {
    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("method.parameter.type.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EndpointBundle.message("method.parameter.type.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/appengine/validation/MethodParameterTypeInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = EndpointBundle.message("method.parameter.type.short.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/appengine/validation/MethodParameterTypeInspection", "getShortName"));
        }
        return string;
    }

    public boolean isValidArrayOrPrimitiveType(PsiType type, Project project) {
        if (type instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)type;
            if (arrayType.getComponentType() instanceof PsiPrimitiveType) {
                return true;
            }
            return this.isValidInnerArrayType(arrayType.getComponentType(), project);
        }
        PsiClassType collectionType = JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.util.Collection");
        if (collectionType.isAssignableFrom(type)) {
            assert (type instanceof PsiClassType);
            PsiClassType classType = (PsiClassType)type;
            PsiType[] typeParams = classType.getParameters();
            assert (typeParams.length > 0);
            return this.isValidInnerArrayType(typeParams[0], project);
        }
        return true;
    }

    public boolean isValidInnerArrayType(PsiType type, Project project) {
        if (type instanceof PsiArrayType) {
            return false;
        }
        PsiClassType collectionType = JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.util.Collection");
        return !collectionType.isAssignableFrom(type);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/google/gct/idea/appengine/validation/MethodParameterTypeInspection", "buildVisitor"));
        }
        EndpointPsiElementVisitor endpointPsiElementVisitor = new EndpointPsiElementVisitor(){

            public void visitParameter(PsiParameter psiParameter) {
                Project project;
                if (!EndpointUtilities.isEndpointClass((PsiElement)psiParameter)) {
                    return;
                }
                if (this.hasTransformer((PsiElement)psiParameter)) {
                    return;
                }
                PsiElement psiElement = psiParameter.getDeclarationScope();
                if (psiElement instanceof PsiMethod) {
                    if (!EndpointUtilities.isApiMethod((PsiMethod)psiElement)) {
                        return;
                    }
                } else {
                    return;
                }
                try {
                    project = psiParameter.getContainingFile().getProject();
                    if (project == null) {
                        return;
                    }
                }
                catch (PsiInvalidElementAccessException e) {
                    EndpointInspectionBase.LOG.error("Error getting project with parameter " + psiParameter.getText(), (Throwable)e);
                    return;
                }
                if (!MethodParameterTypeInspection.this.isValidArrayOrPrimitiveType(psiParameter.getType(), project)) {
                    holder.registerProblem((PsiElement)psiParameter, "Illegal nested collection type " + psiParameter.getType().getPresentableText() + ".", LocalQuickFix.EMPTY_ARRAY);
                }
            }
        };
        if (endpointPsiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/appengine/validation/MethodParameterTypeInspection", "buildVisitor"));
        }
        return endpointPsiElementVisitor;
    }
}

