/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.common.annotations.VisibleForTesting;
import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiUtilBase;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodNameInspection
extends EndpointInspectionBase {
    private static final String API_NAME_ATTRIBUTE = "name";
    private static final Pattern API_NAME_PATTERN = Pattern.compile("^\\w+(\\.\\w+)*$");

    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("method.name.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EndpointBundle.message("method.name.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/appengine/validation/MethodNameInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = EndpointBundle.message("method.name.short.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/appengine/validation/MethodNameInspection", "getShortName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/google/gct/idea/appengine/validation/MethodNameInspection", "buildVisitor"));
        }
        EndpointPsiElementVisitor endpointPsiElementVisitor = new EndpointPsiElementVisitor(){

            public void visitAnnotation(PsiAnnotation annotation) {
                if (!EndpointUtilities.isEndpointClass((PsiElement)annotation)) {
                    return;
                }
                if (!annotation.getQualifiedName().equals("com.google.api.server.spi.config.ApiMethod")) {
                    return;
                }
                PsiAnnotationMemberValue memberValue = annotation.findAttributeValue(MethodNameInspection.API_NAME_ATTRIBUTE);
                if (memberValue == null) {
                    return;
                }
                String nameValueWithQuotes = memberValue.getText();
                String nameValue = EndpointUtilities.removeBeginningAndEndingQuotes(nameValueWithQuotes);
                if (nameValue.isEmpty()) {
                    return;
                }
                if (!API_NAME_PATTERN.matcher(EndpointUtilities.collapseSequenceOfDots(nameValue)).matches()) {
                    holder.registerProblem((PsiElement)memberValue, "Invalid method name: letters, digits, underscores and dots are acceptable characters. Leading and trailing dots are prohibited.", new LocalQuickFix[]{new MyQuickFix()});
                }
            }
        };
        if (endpointPsiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/appengine/validation/MethodNameInspection", "buildVisitor"));
        }
        return endpointPsiElementVisitor;
    }

    public class MyQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            String string = this.getFamilyName() + ": Rename API method";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/appengine/validation/MethodNameInspection$MyQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = MethodNameInspection.this.getDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/appengine/validation/MethodNameInspection$MyQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/gct/idea/appengine/validation/MethodNameInspection$MyQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/google/gct/idea/appengine/validation/MethodNameInspection$MyQuickFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element == null) {
                return;
            }
            Editor editor = PsiUtilBase.findEditor((PsiElement)element);
            if (editor == null) {
                return;
            }
            TextRange textRange = ((ProblemDescriptorBase)descriptor).getTextRange();
            editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
            String wordWithQuotes = editor.getSelectionModel().getSelectedText();
            String word = EndpointUtilities.removeBeginningAndEndingQuotes(wordWithQuotes);
            if (word == null || StringUtil.isEmpty((String)word)) {
                return;
            }
            String variant = "\"" + this.getMethodNameSuggestions(word) + "\"";
            LookupManager lookupManager = LookupManager.getInstance((Project)project);
            lookupManager.showLookup(editor, new LookupElement[]{LookupElementBuilder.create((String)variant)});
        }

        @VisibleForTesting
        public String getMethodNameSuggestions(String baseString) {
            if (baseString == null) {
                return null;
            }
            if (baseString.isEmpty()) {
                return "";
            }
            String noInvalidChars = baseString.replaceAll("[^a-zA-Z0-9_.]+", "");
            if (noInvalidChars.isEmpty()) {
                return "";
            }
            if (API_NAME_PATTERN.matcher(noInvalidChars).matches()) {
                return noInvalidChars;
            }
            baseString = noInvalidChars;
            String noSequencingDots = EndpointUtilities.collapseSequenceOfDots(baseString);
            if (API_NAME_PATTERN.matcher(noSequencingDots).matches()) {
                return noSequencingDots;
            }
            baseString = noSequencingDots;
            if (baseString.startsWith(".")) {
                String noLeadingDots = baseString.substring(1);
                if (API_NAME_PATTERN.matcher(noLeadingDots).matches()) {
                    return noLeadingDots;
                }
                if (noLeadingDots.isEmpty()) {
                    return "";
                }
                baseString = noLeadingDots;
            }
            if (baseString.endsWith(".")) {
                String noTrailingDots = baseString.substring(0, baseString.length() - 1);
                if (API_NAME_PATTERN.matcher(noTrailingDots).matches()) {
                    return noTrailingDots;
                }
                if (noTrailingDots.isEmpty()) {
                    return "";
                }
            }
            return "";
        }
    }
}

